<?php

// prefer post over get data
if (count($_POST)) {
    $formdata = $_POST;
} else {
    $formdata = $_GET;
}

// set redirect target if ommited in form
if (!isset($formdata['dummy-target'])) {
    $formdata['dummy-target'] = $_SERVER['HTTP_REFERER'];
}

// language chooser
if (isset($formdata['language']) && count($formdata) == 2) {
    $formdata['dummy-target'] .= '#' . $formdata['language'];
}

// event chooser
if (isset($formdata['event']) && count($formdata) == 2) {
    $formdata['dummy-target'] .= '#' . $formdata['event'];
}

// search in help
if (isset($formdata['search-help']) && count($formdata) == 2) {
    $formdata['dummy-target'] .= '#search=' . $formdata['search-help'];
}

// table actions
if (array_key_exists('search', $formdata) && array_key_exists('table-actions', $formdata)) {
    if ($formdata['search']) { // search term entered
        if (strpos($formdata['dummy-target'], '06.gutschein-listing.html') !== FALSE) {
            $formdata['dummy-target'] = '../../pages/06b.gutschein-search-empty.html#' . $formdata['search'];
        }
        if (strpos($formdata['dummy-target'], '08.ticket-listing.html') !== FALSE) {
            $formdata['dummy-target'] = '../../pages/08c.ticket-search-empty.html#' . $formdata['search'];
        }
    }
}

// ticket details
if (array_key_exists('dummy-form-name', $formdata) && $formdata['dummy-form-name'] == 'ticket-details') {
    if ($formdata['action'] == 'edit') {
        $formdata['dummy-target'] =  $formdata['dummy-target-edit'];
    }
    if ($formdata['action'] == 'lock') {
        $formdata['dummy-target'] =  $formdata['dummy-target-lock'];
    }
    if ($formdata['action'] == 'alert') {
        $formdata['dummy-target'] =  $formdata['dummy-target-alert'];
    }
}

if (array_key_exists('ticket-email', $formdata)) { // Ticket Form
    if ($formdata['restart'] == 'false') {
        $formdata['dummy-target'] = '../../pages/08c.ticket-listing-meldung-erfolg.html';
    } else {
        $formdata['dummy-target'] = '../../pages/09.01.ticket-erstellen.html';
    }
}

if (isset($formdata['dl'])) {
    $file = $formdata['dl'];
    $size = filesize($file);
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header("Cache-Control: private",false); // required for certain browsers
    header('Content-Disposition: attachment; filename=registration-codes.xlsx');
    header('Content-Transfer-Encoding: binary');
    header('Connection: Keep-Alive');
    header('Expires: 0');
    header('Pragma: public');
    header('Content-Length: ' . $size);
    readfile($file);
    die();
}



// echo "<pre>";
// print_r($formdata);
// exit;

header('Location: ' . $formdata['dummy-target']);
die();
